<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-TOC-Schema"
                              xmlns:wwhtoc="urn:WebWorks-Help-TOC-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwbehaviors wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterTOCSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhtoc" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:value-of select="wwprogress:Start(1)" />

     <xsl:variable name="VarFilesDocument" select="." />

     <!-- Load splits -->
     <!--             -->
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <xsl:for-each select="$VarSplits[1]">
      <!-- Split -->
      <!--       -->
      <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterTOCSplitFileType))[1]" />

      <!-- Transform -->
      <!--           -->
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Load document -->
        <!--               -->
        <xsl:variable name="VarTOC" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

        <xsl:call-template name="TableOfContents">
         <xsl:with-param name="ParamSplits" select="$VarSplits" />
         <xsl:with-param name="ParamSplit" select="$VarSplit" />
         <xsl:with-param name="ParamTOC" select="$VarTOC" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xml', '1.0', 'yes')" />
      </xsl:if>

      <!-- Report Files -->
      <!--              -->
      <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
       <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
       <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
      </wwfiles:File>
     </xsl:for-each>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="TableOfContents">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamTOC" />

  <wwhtoc:WebWorksHelpTOC version="5.0">
   <!-- Generate TOC? -->
   <!--               -->
   <xsl:if test="wwprojext:GetFormatSetting('toc-generate', 'true') = 'true'">
    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParent" select="$ParamTOC/wwtoc:TableOfContents" />
    </xsl:call-template>
   </xsl:if>
  </wwhtoc:WebWorksHelpTOC>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParent" />

  <xsl:for-each select="$ParamParent/wwtoc:Entry">
   <xsl:variable name="VarEntry" select="." />

   <wwhtoc:i>
    <xsl:attribute name="t">
     <xsl:call-template name="Paragraph">
      <xsl:with-param name="ParamParagraph" select="$VarEntry/wwdoc:Paragraph" />
     </xsl:call-template>
    </xsl:attribute>
    <xsl:if test="string-length($VarEntry/@path) &gt; 0">
     <xsl:attribute name="l">
      <xsl:value-of select="number($VarEntry/@fileposition) - 1" />
      <xsl:if test="$VarEntry/@first != 'true'">
       <xsl:text>#</xsl:text>
       <xsl:value-of select="$VarEntry/@linkid" />
      </xsl:if>
     </xsl:attribute>
    </xsl:if>

    <!-- TOC Icon -->
    <!--          -->
    <xsl:variable name="VarTOCIconMarkers" select="$VarEntry/wwbehaviors:Paragraph/wwbehaviors:Marker[@behavior = 'toc-icon-webworks-help']" />

    <xsl:if test="count($VarTOCIconMarkers) &gt; 0">
     <xsl:variable name="VarTOCIconMarker" select="$VarTOCIconMarkers[count($VarTOCIconMarkers)]" />
     <xsl:variable name="VarTOCIconText">
      <xsl:for-each select="$VarTOCIconMarker//wwdoc:TextRun/wwdoc:Text">
       <xsl:value-of select="@value" />
      </xsl:for-each>
     </xsl:variable>

     <!-- Validate value -->
     <!--                -->
     <xsl:variable name="VarCollapseValue1" select="wwstring:ReplaceWithExpression($VarTOCIconText, ' e=&quot;[^&quot;]*&quot;', '')" />
     <xsl:variable name="VarCollapseValue2" select="wwstring:ReplaceWithExpression($VarCollapseValue1, '^[ ]+|[ ]+$', '')" />
     <xsl:variable name="VarCollapseValue3" select="wwstring:Replace($VarCollapseValue2, 'c=&quot;', '')" />
     <xsl:variable name="VarCollapseValue4" select="wwstring:ReplaceWithExpression($VarCollapseValue3, '&quot;$', '')" />
     <xsl:variable name="VarCollapseValidate" select="wwstring:ReplaceWithExpression($VarCollapseValue4, '^[a-zA-Z0-9_\-/\\]+\.gif$', '')" />

     <xsl:choose>
      <xsl:when test="string-length($VarCollapseValidate) = 0">
       <xsl:attribute name="c">
        <xsl:value-of select="$VarCollapseValue4" />
       </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="wwlog:Warning(concat('Unable to validate collapse value in TOCIconMarker: ', $VarTOCIconText, ': Skipping collapse value.'))" />
      </xsl:otherwise>
     </xsl:choose>

     <xsl:variable name="VarExpandValue1" select="wwstring:ReplaceWithExpression($VarTOCIconText, 'c=&quot;[^&quot;]*&quot; ', '')" />
     <xsl:variable name="VarExpandValue2" select="wwstring:ReplaceWithExpression($VarExpandValue1, '^[ ]+|[ ]+$', '')" />
     <xsl:variable name="VarExpandValue3" select="wwstring:Replace($VarExpandValue2, 'e=&quot;', '')" />
     <xsl:variable name="VarExpandValue4" select="wwstring:ReplaceWithExpression($VarExpandValue3, '&quot;$', '')" />
     <xsl:variable name="VarExpandValidate" select="wwstring:ReplaceWithExpression($VarCollapseValue4, '^[a-zA-Z0-9_\-/\\]+\.gif$', '')" />

     <xsl:choose>
      <xsl:when test="string-length($VarExpandValidate) = 0">
       <xsl:attribute name="e">
        <xsl:value-of select="$VarExpandValue4" />
       </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="wwlog:Warning(concat('Unable to validate expand value in TOCIconMarker: ', $VarTOCIconText, ': Skipping expand value.'))" />
      </xsl:otherwise>
     </xsl:choose>

    </xsl:if>

    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParent" select="$VarEntry" />
    </xsl:call-template>
   </wwhtoc:i>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamParagraph" />

  <xsl:variable name="VarText">
   <xsl:for-each select="$ParamParagraph/wwdoc:Number/wwdoc:Text | $ParamParagraph/wwdoc:TextRun/wwdoc:Text">
    <xsl:value-of select="@value" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:value-of select="normalize-space($VarText)" />
 </xsl:template>
</xsl:stylesheet>
